/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.web.domain.entity.FixFile;
import com.ruoyi.web.service.FixFileService;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/file"})
public class FixFileController
extends BaseController {
    @Resource
    private FixFileService fixFileService;

    @GetMapping(value={"/{fileName}"})
    public AjaxResult getInfo(@PathVariable(value="fileName") String fileName) {
        return this.success((Object)this.fixFileService.selectFixFileByFileName(fileName));
    }

    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody FixFile fixFile) {
        if (fixFile == null || StringUtils.isEmpty((String)fixFile.getFileName()) || StringUtils.isEmpty((String)fixFile.getFilePath())) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38");
        }
        FixFile selectFile = this.fixFileService.selectFixFileByFileName(fixFile.getFileName());
        if (selectFile == null) {
            this.toAjax(this.fixFileService.insertFixFile(fixFile));
        }
        return this.toAjax(this.fixFileService.updateFixFile(fixFile));
    }
}

