/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.web.domain.entity.SqcLead;
import com.ruoyi.web.service.SqcLeadService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/lead"})
public class SqcLeadController
extends BaseController {
    @Autowired
    private SqcLeadService sqcLeadService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(SqcLead sqcLead) {
        this.startPage();
        List list = this.sqcLeadService.selectSqcLeadList(sqcLead);
        return this.getDataTable(list);
    }

    @Log(title="ldbz", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SqcLead sqcLead) {
        List list = this.sqcLeadService.selectSqcLeadList(sqcLead);
        ExcelUtil util = new ExcelUtil(SqcLead.class);
        util.exportExcel(response, list, "ldbz\u6570\u636e");
    }

    @GetMapping(value={"/{name}"})
    public AjaxResult getInfo(@PathVariable(value="name") String name) {
        return this.success((Object)this.sqcLeadService.selectSqcLeadByName(name));
    }

    @Log(title="ldbz", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SqcLead sqcLead) {
        return this.toAjax(this.sqcLeadService.insertSqcLead(sqcLead));
    }

    @Log(title="ldbz", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SqcLead sqcLead) {
        return this.toAjax(this.sqcLeadService.updateSqcLead(sqcLead));
    }

    @Log(title="ldbz", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{names}"})
    public AjaxResult remove(@PathVariable String[] names) {
        return this.toAjax(this.sqcLeadService.deleteSqcLeadByNames(names));
    }
}

