/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.service;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.web.domain.VO.SqcLocationVO;
import com.ruoyi.web.domain.entity.SqcLocation;
import com.ruoyi.web.mapper.SqcLocationMapper;
import com.ruoyi.web.mapper.SqcPersonMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqcLocationService {
    @Autowired
    private SqcLocationMapper sqcLocationMapper;
    @Autowired
    private SqcPersonMapper sqcPersonMapper;

    public List<SqcLocationVO> selectInfo(SqcLocation sqcLocation) {
        List sqcLocationVOS = this.sqcLocationMapper.selectInfo(sqcLocation);
        Set serialList = sqcLocationVOS.stream().map(SqcLocationVO::getSerial).filter(Objects::nonNull).collect(Collectors.toSet());
        List family = serialList.isEmpty() ? new ArrayList() : this.sqcPersonMapper.getFamily(serialList);
        Map<String, String> familyMap = family.stream().collect(Collectors.toMap(k -> (String)k.get("serial"), v -> (String)v.get("family")));
        sqcLocationVOS.forEach(sqcLocationVO -> sqcLocationVO.setFamily((String)familyMap.get(sqcLocationVO.getSerial())));
        return sqcLocationVOS;
    }

    public List<SqcLocation> selectSqcLocationList(SqcLocation sqcLocation) {
        return this.sqcLocationMapper.selectSqcLocationList(sqcLocation);
    }

    public int insertSqcLocation(SqcLocation sqcLocation) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sqcLocation.getLocationX(), sqcLocation.getLocationY(), sqcLocation.getArea()})) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        return this.sqcLocationMapper.insertSqcLocation(sqcLocation);
    }

    public int updateSqcLocation(SqcLocation sqcLocation) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sqcLocation.getLocationX(), sqcLocation.getLocationY(), sqcLocation.getArea()})) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        return this.sqcLocationMapper.updateSqcLocation(sqcLocation);
    }

    public int deleteSqcLocation(SqcLocation sqcLocation) {
        return this.sqcLocationMapper.deleteSqcLocation(sqcLocation);
    }
}

