/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.web.domain.entity.SqcArea;
import com.ruoyi.web.service.SqcAreaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/area"})
public class SqcAreaController
extends BaseController {
    @Autowired
    private SqcAreaService sqcAreaService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(SqcArea sqcArea) {
        List list = this.sqcAreaService.selectSqcAreaList(sqcArea);
        return this.getDataTable(list);
    }

    @Log(title="\u533a\u57df", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult add(@RequestBody SqcArea sqcArea) {
        if (StringUtils.isBlank((CharSequence)sqcArea.getArea()) || StringUtils.isBlank((CharSequence)sqcArea.getPath())) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.toAjax(this.sqcAreaService.insertSqcArea(sqcArea));
    }

    @PostMapping(value={"/edit"})
    @Log(title="\u533a\u57df", businessType=BusinessType.UPDATE)
    public AjaxResult edit(@RequestBody SqcArea sqcArea) {
        return this.toAjax(this.sqcAreaService.updateSqcArea(sqcArea));
    }

    @Log(title="\u533a\u57df", businessType=BusinessType.DELETE)
    @GetMapping(value={"/remove"})
    public AjaxResult remove(@RequestParam String[] areas) {
        return this.toAjax(this.sqcAreaService.deleteSqcAreaByAreas(areas));
    }
}

