/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.web.domain.entity.SqcLocation;
import com.ruoyi.web.service.SqcLocationService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/location"})
public class SqcLocationController
extends BaseController {
    @Autowired
    private SqcLocationService sqcLocationService;

    @GetMapping(value={"/listInfo"})
    public TableDataInfo listInfo(SqcLocation sqcLocation) {
        List list = this.sqcLocationService.selectInfo(sqcLocation);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/list"})
    public TableDataInfo list(SqcLocation sqcLocation) {
        this.startPage();
        List list = this.sqcLocationService.selectSqcLocationList(sqcLocation);
        return this.getDataTable(list);
    }

    @Log(title="location", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SqcLocation sqcLocation) {
        List list = this.sqcLocationService.selectSqcLocationList(sqcLocation);
        ExcelUtil util = new ExcelUtil(SqcLocation.class);
        util.exportExcel(response, list, "location\u6570\u636e");
    }

    @Log(title="location", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SqcLocation sqcLocation) {
        return this.toAjax(this.sqcLocationService.insertSqcLocation(sqcLocation));
    }

    @Log(title="location", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public AjaxResult edit(@RequestBody SqcLocation sqcLocation) {
        return this.toAjax(this.sqcLocationService.updateSqcLocation(sqcLocation));
    }

    @Log(title="location", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    public AjaxResult remove(@RequestBody SqcLocation sqcLocation) {
        return this.toAjax(this.sqcLocationService.deleteSqcLocation(sqcLocation));
    }
}

