/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.web.domain.entity.SqcMeshRegion;
import com.ruoyi.web.service.SqcMeshRegionService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/region"})
public class SqcMeshRegionController
extends BaseController {
    @Autowired
    private SqcMeshRegionService sqcMeshRegionService;

    @GetMapping(value={"/statistics"})
    public TableDataInfo statistics() {
        List statistics = this.sqcMeshRegionService.statistics();
        return this.getDataTable(statistics);
    }

    @GetMapping(value={"/list"})
    public TableDataInfo list(SqcMeshRegion sqcMeshRegion) {
        this.startPage();
        List list = this.sqcMeshRegionService.selectSqcMeshRegionList(sqcMeshRegion);
        return this.getDataTable(list);
    }

    @Log(title="meshRegion", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SqcMeshRegion sqcMeshRegion) {
        List list = this.sqcMeshRegionService.selectSqcMeshRegionList(sqcMeshRegion);
        ExcelUtil util = new ExcelUtil(SqcMeshRegion.class);
        util.exportExcel(response, list, "meshRegion\u6570\u636e");
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return this.success((Object)this.sqcMeshRegionService.selectSqcMeshRegionByMeshRegionType(id));
    }

    @Log(title="meshRegion", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SqcMeshRegion sqcMeshRegion) {
        return this.toAjax(this.sqcMeshRegionService.insertSqcMeshRegion(sqcMeshRegion));
    }

    @Log(title="meshRegion", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SqcMeshRegion sqcMeshRegion) {
        return this.toAjax(this.sqcMeshRegionService.updateSqcMeshRegion(sqcMeshRegion));
    }

    @Log(title="meshRegion", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.sqcMeshRegionService.deleteSqcMeshRegionByMeshRegionTypes(ids));
    }
}

