/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.web.domain.entity.SqcPerson;
import com.ruoyi.web.service.SqcPersonService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/person"})
public class SqcPersonController
extends BaseController {
    @Autowired
    private SqcPersonService sqcPersonService;

    @GetMapping(value={"/list/head"})
    public TableDataInfo listHead(SqcPerson sqcPerson) {
        List list = this.sqcPersonService.selectSqcPersonHeadList(sqcPerson);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/list"})
    public TableDataInfo list(SqcPerson sqcPerson) {
        this.startPage();
        List list = this.sqcPersonService.selectSqcPersonList(sqcPerson);
        return this.getDataTable(list);
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/importData"})
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil util = new ExcelUtil(SqcPerson.class);
        List userList = util.importExcel(file.getInputStream());
        String msg = this.sqcPersonService.importUser(userList);
        return this.success(msg);
    }

    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/template"})
    public void template(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("personTemplate.xls");
            InputStream inputStream = classPathResource.getInputStream();
            BufferedInputStream fis = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String("personTemplate.xls".getBytes(), StandardCharsets.ISO_8859_1));
            response.addHeader("Content-Length", "" + buffer.length);
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            ((OutputStream)out).write(buffer);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SqcPerson sqcPerson) {
        List list = this.sqcPersonService.selectSqcPersonList(sqcPerson);
        ExcelUtil util = new ExcelUtil(SqcPerson.class);
        util.exportExcel(response, list, "\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011\u6570\u636e");
    }

    @GetMapping(value={"/countByLocal"})
    public AjaxResult countByLocal() {
        return this.success((Object)this.sqcPersonService.countByLocal());
    }

    @GetMapping(value={"/countByAge"})
    public AjaxResult countByAge() {
        return this.success((Object)this.sqcPersonService.countByAge());
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return this.success((Object)this.sqcPersonService.selectSqcPersonById(id));
    }

    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SqcPerson sqcPerson) {
        return this.toAjax(this.sqcPersonService.insertSqcPerson(sqcPerson));
    }

    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SqcPerson sqcPerson) {
        return this.toAjax(this.sqcPersonService.updateSqcPerson(sqcPerson));
    }

    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.sqcPersonService.deleteSqcPersonByIds(ids));
    }
}

