/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.service;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.web.domain.entity.SqcPerson;
import com.ruoyi.web.mapper.SqcPersonMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SqcPersonService {
    private static final Logger log = LoggerFactory.getLogger(SqcPersonService.class);
    @Autowired
    private SqcPersonMapper sqcPersonMapper;

    public Map<String, Integer> countByLocal() {
        int all = this.sqcPersonMapper.countPerson();
        int household = this.sqcPersonMapper.countHousehold();
        int localPerson = this.sqcPersonMapper.countLocalPerson();
        int outPerson = this.sqcPersonMapper.countOutPerson();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("all", all);
        map.put("household", household);
        map.put("localPerson", localPerson);
        map.put("outPerson", outPerson);
        return map;
    }

    public Map<String, Integer> countByAge() {
        List maps = this.sqcPersonMapper.countByAge();
        return maps.stream().collect(Collectors.toMap(e -> e.get("age_group").toString(), e -> Integer.valueOf(e.get("number_of_users").toString()), (k1, k2) -> k1));
    }

    public SqcPerson selectSqcPersonById(Long id) {
        return this.sqcPersonMapper.selectSqcPersonById(id);
    }

    public List<SqcPerson> selectSqcPersonList(SqcPerson sqcPerson) {
        return this.sqcPersonMapper.selectSqcPersonList(sqcPerson);
    }

    public List<SqcPerson> selectSqcPersonHeadList(SqcPerson sqcPerson) {
        return this.sqcPersonMapper.selectSqcPersonHeadList(sqcPerson);
    }

    public int insertSqcPerson(SqcPerson sqcPerson) {
        return this.sqcPersonMapper.insertSqcPerson(sqcPerson);
    }

    public int updateSqcPerson(SqcPerson sqcPerson) {
        return this.sqcPersonMapper.updateSqcPerson(sqcPerson);
    }

    public int deleteSqcPersonByIds(Long[] ids) {
        return this.sqcPersonMapper.deleteSqcPersonByIds(ids);
    }

    public int deleteSqcPersonById(Long id) {
        return this.sqcPersonMapper.deleteSqcPersonById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public String importUser(List<SqcPerson> userList) {
        if (userList == null || userList.isEmpty()) {
            return "";
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        SqcPerson sqcPerson = new SqcPerson();
        SqcPerson checkPerson = new SqcPerson();
        checkPerson.setRelationType("\u6237\u4e3b");
        for (SqcPerson user : userList) {
            try {
                String msg;
                if (StringUtils.isEmpty((String)user.getSfz())) {
                    msg = "<br/>" + ++failureNum + "\u3001\u4eba\u5458 " + user.getName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                    failureMsg.append(msg + "\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    log.error(msg, (Object)"\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                if (StringUtils.isEmpty((String)user.getSerial())) {
                    msg = "<br/>" + ++failureNum + "\u3001\u4eba\u5458 " + user.getName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                    failureMsg.append(msg + "\u7f16\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    log.error(msg, (Object)"\u7f16\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                if (StringUtils.isEmpty((String)user.getRelationType())) {
                    msg = "<br/>" + ++failureNum + "\u3001\u4eba\u5458 " + user.getName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                    failureMsg.append(msg + "\u5173\u7cfb\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    log.error(msg, (Object)"\u5173\u7cfb\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                List checkHead = null;
                if (checkPerson.getRelationType().equals(user.getRelationType())) {
                    checkPerson.setSerial(user.getSerial());
                    checkHead = this.sqcPersonMapper.selectSqcPersonList(checkPerson);
                }
                sqcPerson.setSfz(user.getSfz());
                List us = this.sqcPersonMapper.selectSqcPersonList(sqcPerson);
                if (us != null && !us.isEmpty()) {
                    this.sqcPersonMapper.updateSqcPersonBySfz(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u4eba\u5458 " + user.getName() + " \u66f4\u65b0\u6210\u529f");
                    continue;
                }
                if (checkHead != null && !checkHead.isEmpty()) {
                    String msg2 = "<br/>" + ++failureNum + "\u3001\u4eba\u5458 " + user.getName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                    failureMsg.append(msg2).append(user.getSerial()).append("\u6237\u4e3b\u5df2\u5b58\u5728");
                    log.error(msg2, (Object)"\u6237\u4e3b\u4e0d\u80fd\u91cd\u590d");
                    continue;
                }
                this.sqcPersonMapper.insertSqcPerson(user);
                successMsg.append("<br/>" + ++successNum + "\u3001\u4eba\u5458 " + user.getName() + " \u5bfc\u5165\u6210\u529f");
            }
            catch (Exception e) {
                String msg = "<br/>" + ++failureNum + "\u3001\u4eba\u5458 " + user.getName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, (Throwable)e);
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u9519\u8bef\u5982\u4e0b\uff1a");
            return failureMsg.toString();
        }
        successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
        return successMsg.toString();
    }
}

